/*
 * Decompiled with CFR 0.152.
 */
package xlog.micro;

import eawag.model.AbstractParser;
import eawag.model.Agent;
import eawag.model.Fixup;
import eawag.model.Swarm;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import xlog.micro.ObjectReflect;

public class ReflectBinaryParser
extends AbstractParser {
    public static final int TAG_NULL = 78;
    public static final int TAG_ARRAY = 65;
    public static final int TAG_STRUCT = 83;
    public static final int TAG_REF = 82;
    public static final int TAG_CLASS = 67;
    public static final int TAG_STRING = 85;
    public static final int TAG_VALUE = 86;
    public static final int TAG_LONG = 76;
    public static final int TAG_INT = 73;
    public static final int TAG_SHORT = 74;
    public static final int TAG_BYTE = 75;
    public static final int TAG_CHAR = 77;
    public static final int TAG_BOOLEAN = 66;
    public static final int TAG_AGENT = 88;
    public static final int TAG_SWARM = 89;
    private static final int RES_NONE = 0;
    private static final int RES_OBJECT = 1;
    private static final int RES_LONG = 3;
    private static final int RES_BOOLEAN = 4;
    private static final int RES_CHAR = 5;
    private DataInputStream in;
    private int restype;
    private Object resobject;
    private long reslong;
    private boolean resboolean;
    private char reschar;

    public void setInput(InputStream inputStream) {
        this.in = new DataInputStream(inputStream);
    }

    protected void err(String string) {
        this.err.println(this.obj + this.sb.toString() + ": " + string + ".");
        this.error = true;
    }

    public void parseAny(boolean bl) throws IOException, IllegalAccessException {
        int n = this.in.read();
        switch (n) {
            case 78: {
                this.setObject(null);
                break;
            }
            case 65: {
                String string = this.in.readUTF();
                int n2 = this.in.readInt();
                Object object = null;
                try {
                    object = ObjectReflect.array(string, n2);
                }
                catch (Exception exception) {
                    this.err("Cant make instance for class " + string);
                }
                Class clazz = null;
                if (!(string.equals("[I") || string.equals("[B") || string.equals("[Z") || string.equals("[C"))) {
                    String string2 = string.substring(1);
                    if (string2.charAt(0) == 'L') {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    try {
                        clazz = ObjectReflect.find(string2);
                    }
                    catch (Exception exception) {
                        this.err("Cant make class " + string2);
                    }
                }
                for (int i = 0; i < n2; ++i) {
                    int n3 = this.sb.length();
                    this.sb.append('[');
                    this.sb.append(i);
                    this.sb.append(']');
                    this.parseAny(true);
                    this.sb.setLength(n3);
                    if (object == null) continue;
                    if (string.equals("[I")) {
                        ((int[])object)[i] = (int)this.getLong();
                        continue;
                    }
                    if (string.equals("[B")) {
                        ((byte[])object)[i] = (byte)this.getLong();
                        continue;
                    }
                    if (string.equals("[Z")) {
                        ((boolean[])object)[i] = this.getBoolean();
                        continue;
                    }
                    if (string.equals("[C")) {
                        ((char[])object)[i] = this.getChar();
                        continue;
                    }
                    ((Object[])object)[i] = this.getObject(clazz);
                }
                this.setObject(object);
                break;
            }
            case 83: {
                String string = this.in.readUTF();
                int n4 = this.in.readShort();
                Object var5_10 = null;
                Class<?> clazz = null;
                ObjectReflect objectReflect = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (Exception exception) {
                    this.err("Cant make class " + string);
                }
                try {
                    var5_10 = clazz.newInstance();
                }
                catch (Exception exception) {
                    this.err("Cant make instance for class " + string);
                }
                if (var5_10 instanceof Swarm) {
                    Swarm swarm = var5_10;
                    swarm.unregisterall();
                }
                objectReflect = ObjectReflect.lookup(clazz);
                for (int i = 0; i < n4; ++i) {
                    String string3 = this.in.readUTF();
                    int n5 = this.sb.length();
                    this.sb.append('.');
                    this.sb.append(string3);
                    this.parseAny(true);
                    this.sb.setLength(n5);
                    if (var5_10 == null) continue;
                    String string4 = objectReflect.type(string3);
                    try {
                        if (string4.equals("int") || string4.equals("byte")) {
                            objectReflect.set(var5_10, string3, new Long(this.getLong()));
                            continue;
                        }
                        if (string4.equals("boolean")) {
                            objectReflect.set(var5_10, string3, new Boolean(this.getBoolean()));
                            continue;
                        }
                        if (string4.equals("char")) {
                            objectReflect.set(var5_10, string3, new Character(this.getChar()));
                            continue;
                        }
                        Class clazz2 = null;
                        try {
                            clazz2 = ObjectReflect.find(string4);
                        }
                        catch (Exception exception) {
                            this.err("Cant make class " + string4);
                        }
                        objectReflect.set(var5_10, string3, this.getObject(clazz2));
                        continue;
                    }
                    catch (Exception exception) {
                        this.err("Cant set field " + string3);
                    }
                }
                this.setObject(var5_10);
                break;
            }
            case 85: {
                this.setObject(this.in.readUTF());
                break;
            }
            case 86: {
                this.parseAny(true);
                this.setObject(new Long(this.getLong()));
                break;
            }
            case 67: {
                String string = this.in.readUTF();
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (Exception exception) {
                    this.err("Cant make class " + string);
                }
                this.setObject(clazz);
                break;
            }
            case 76: {
                this.restype = 3;
                this.reslong = this.in.readLong();
                break;
            }
            case 73: {
                this.restype = 3;
                this.reslong = this.in.readInt();
                break;
            }
            case 74: {
                this.restype = 3;
                this.reslong = this.in.readShort();
                break;
            }
            case 75: {
                this.restype = 3;
                this.reslong = this.in.readByte();
                break;
            }
            case 77: {
                this.restype = 5;
                this.reschar = this.in.readChar();
                break;
            }
            case 66: {
                this.restype = 4;
                this.resboolean = this.in.readBoolean();
                break;
            }
            case 82: {
                String string = this.in.readUTF();
                if (bl) {
                    Agent agent = this.root.findBySerno(string);
                    if (agent == null) {
                        Fixup fixup = new Fixup();
                        fixup.obj = this.obj;
                        fixup.tpath = this.sb.toString();
                        fixup.tvalue = string;
                        this.fixups.addElement(fixup);
                    }
                    this.setObject(agent);
                    break;
                }
                this.err("Identifier not allowed");
                this.restype = 0;
                break;
            }
            default: {
                this.err("illegal tag '" + (char)n + "'");
                this.restype = 0;
            }
        }
    }

    public void endShared(Object object) {
    }

    public long getLong() {
        if (this.restype == 3) {
            return this.reslong;
        }
        if (this.restype == 1 && this.resobject instanceof Long) {
            this.err("long expected, Long found");
            return (Long)this.resobject;
        }
        this.err("long expected");
        return 0L;
    }

    public char getChar() {
        if (this.restype == 5) {
            return this.reschar;
        }
        this.err("char expected");
        return '\u0000';
    }

    public boolean getBoolean() {
        if (this.restype == 4) {
            return this.resboolean;
        }
        this.err("boolean expected");
        return false;
    }

    public boolean hasObject(Class clazz) {
        if (this.restype != 1) {
            return false;
        }
        if (this.resobject == null) {
            return true;
        }
        return clazz == null || clazz.isAssignableFrom(this.resobject.getClass());
    }

    public Object getObject(Class clazz) {
        if (this.hasObject(clazz)) {
            return this.resobject;
        }
        this.err("Object " + clazz != null ? clazz.getName() : " missing");
        return null;
    }

    public void setObject(Object object) {
        this.restype = 1;
        this.resobject = object;
    }

    public int parseAgents(Swarm swarm, int n, boolean bl) throws IOException, IllegalAccessException {
        int n2 = this.in.readShort();
        for (int i = 0; i < n2; ++i) {
            n = this.parseAgent(swarm, n, bl);
        }
        return n;
    }

    public int parseAgent(Swarm swarm, int n, boolean bl) throws IllegalAccessException, IOException {
        byte by = this.in.readByte();
        this.obj = this.in.readUTF();
        this.parseAny(false);
        Class<?> clazz = null;
        String string = "eawag.model.Agent";
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            this.err("Cant make class " + string);
        }
        Agent agent = (Agent)this.getObject(clazz);
        this.endShared(agent);
        if (agent != null) {
            if (this.obj != null) {
                if (this.root.findBySerno(this.obj) == null) {
                    agent.serno = this.obj;
                } else {
                    this.err("Duplicate agent " + this.obj);
                }
            }
            if (bl) {
                if (swarm.register(agent, n)) {
                    ++n;
                } else {
                    this.err("Constraint violation " + agent);
                }
            } else {
                swarm.add(agent, n);
                ++n;
            }
        }
        switch (by) {
            case 88: {
                if (!(agent instanceof Swarm)) break;
                this.err("Swarm not expected");
                break;
            }
            case 89: {
                if (agent instanceof Swarm) {
                    Swarm swarm2 = (Swarm)agent;
                    this.parseAgents(swarm2, swarm2.child.length, false);
                    break;
                }
                n = this.parseAgents(swarm, n, bl);
                this.err("Swarm expected");
                break;
            }
            default: {
                this.err("illegal tag '" + (char)by + "'");
            }
        }
        return n;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

