/*
 * Decompiled with CFR 0.152.
 */
package xlog.micro;

import eawag.grid.Bug;
import eawag.grid.Depiction;
import eawag.grid.Grid;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class QuicksilverCanvas
extends Canvas {
    public static final int[] clut = new int[65];
    public Grid grid;

    public void setBean(Object object) {
        this.grid = (Grid)object;
    }

    public Object getBean() {
        return this.grid;
    }

    public Image getImage(Depiction depiction, int n) {
        Image image = (Image)depiction.cache.get("javax.microedition.lcdui.Image");
        if (image != null && image.getWidth() == n && image.getHeight() == n) {
            return image;
        }
        image = Image.createImage((int)n, (int)n);
        Graphics graphics = image.getGraphics();
        for (int i = 0; i < depiction.hcell; ++i) {
            int n2 = (i * n + depiction.hcell / 2) / depiction.hcell;
            int n3 = ((i + 1) * n + depiction.hcell / 2) / depiction.hcell;
            for (int j = 0; j < depiction.wcell; ++j) {
                int n4 = (j * n + depiction.wcell / 2) / depiction.wcell;
                int n5 = ((j + 1) * n + depiction.wcell / 2) / depiction.wcell;
                byte by = depiction.bits[j][i];
                graphics.setColor(clut[by]);
                graphics.fillRect(n4, n2, n5 - n4, n3 - n2);
            }
        }
        depiction.cache.put("javax.microedition.lcdui.Image", image);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics graphics) {
        QuicksilverCanvas quicksilverCanvas = this;
        synchronized (quicksilverCanvas) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.grid == null) {
                return;
            }
            int n = Math.max(1, Math.min(this.getWidth() / this.grid.xsize, this.getHeight() / this.grid.ysize));
            int n2 = (this.getWidth() - this.grid.xsize * n) / 2;
            int n3 = (this.getHeight() - this.grid.ysize * n) / 2;
            for (int i = 0; i < this.grid.zsize; ++i) {
                for (int j = 0; j < this.grid.ysize; ++j) {
                    int n4 = n3 + j * n;
                    for (int k = 0; k < this.grid.xsize; ++k) {
                        int n5 = n2 + k * n;
                        Bug bug = this.grid.bugs[i][k][j];
                        if (bug == null || bug.depict == null) continue;
                        Image image = this.getImage(bug.depict, n);
                        graphics.drawImage(image, n5, n4, 20);
                    }
                }
            }
        }
    }

    static {
        QuicksilverCanvas.clut[0] = -16777216;
        QuicksilverCanvas.clut[1] = -15658735;
        QuicksilverCanvas.clut[2] = -14540254;
        QuicksilverCanvas.clut[3] = -13421773;
        QuicksilverCanvas.clut[4] = -12303292;
        QuicksilverCanvas.clut[5] = -11184811;
        QuicksilverCanvas.clut[6] = -10066330;
        QuicksilverCanvas.clut[7] = -8947849;
        QuicksilverCanvas.clut[8] = -7829368;
        QuicksilverCanvas.clut[9] = -6710887;
        QuicksilverCanvas.clut[10] = -5592406;
        QuicksilverCanvas.clut[11] = -4473925;
        QuicksilverCanvas.clut[12] = -3355444;
        QuicksilverCanvas.clut[13] = -2236963;
        QuicksilverCanvas.clut[14] = -1118482;
        QuicksilverCanvas.clut[15] = -1;
        QuicksilverCanvas.clut[16] = -5601423;
        QuicksilverCanvas.clut[17] = -6051215;
        QuicksilverCanvas.clut[18] = -8869263;
        QuicksilverCanvas.clut[19] = -9327979;
        QuicksilverCanvas.clut[20] = -9333334;
        QuicksilverCanvas.clut[21] = -8883798;
        QuicksilverCanvas.clut[22] = -6065750;
        QuicksilverCanvas.clut[23] = -5607033;
        QuicksilverCanvas.clut[24] = -5616071;
        QuicksilverCanvas.clut[25] = -5594311;
        QuicksilverCanvas.clut[26] = -10704327;
        QuicksilverCanvas.clut[27] = -12998038;
        QuicksilverCanvas.clut[28] = -13003350;
        QuicksilverCanvas.clut[29] = -13025110;
        QuicksilverCanvas.clut[30] = -7915094;
        QuicksilverCanvas.clut[31] = -5621384;
        QuicksilverCanvas.clut[32] = -5636096;
        QuicksilverCanvas.clut[33] = -5603328;
        QuicksilverCanvas.clut[34] = -11163136;
        QuicksilverCanvas.clut[35] = -16733653;
        QuicksilverCanvas.clut[36] = -16733526;
        QuicksilverCanvas.clut[37] = -16766038;
        QuicksilverCanvas.clut[38] = -11206486;
        QuicksilverCanvas.clut[39] = -5635968;
        QuicksilverCanvas.clut[40] = -13654;
        QuicksilverCanvas.clut[41] = -720982;
        QuicksilverCanvas.clut[42] = -4849750;
        QuicksilverCanvas.clut[43] = -5570593;
        QuicksilverCanvas.clut[44] = -5578753;
        QuicksilverCanvas.clut[45] = -4871425;
        QuicksilverCanvas.clut[46] = -742657;
        QuicksilverCanvas.clut[47] = -21814;
        QuicksilverCanvas.clut[48] = -35499;
        QuicksilverCanvas.clut[49] = -2987;
        QuicksilverCanvas.clut[50] = -7667883;
        QuicksilverCanvas.clut[51] = -11141217;
        QuicksilverCanvas.clut[52] = -11149313;
        QuicksilverCanvas.clut[53] = -11181825;
        QuicksilverCanvas.clut[54] = -3516929;
        QuicksilverCanvas.clut[55] = -43595;
        QuicksilverCanvas.clut[56] = -65536;
        QuicksilverCanvas.clut[57] = -16640;
        QuicksilverCanvas.clut[58] = -8323328;
        QuicksilverCanvas.clut[59] = -16711872;
        QuicksilverCanvas.clut[60] = -16711681;
        QuicksilverCanvas.clut[61] = -16760577;
        QuicksilverCanvas.clut[62] = -8388353;
        QuicksilverCanvas.clut[63] = -65345;
        QuicksilverCanvas.clut[64] = 0;
    }
}

