/*
 * Decompiled with CFR 0.152.
 */
package eawag.model;

import eawag.model.Agent;
import eawag.model.Top;

public class Swarm
extends Agent {
    public transient Agent[] child = new Agent[0];
    public transient Agent[] _child;
    public boolean randomize;
    public transient boolean _randomize;

    public int indexOf(Agent agent) {
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] != agent) continue;
            return i;
        }
        return -1;
    }

    public Agent findLocalBySerno(String string) {
        for (int i = 0; i < this.child.length; ++i) {
            Agent agent = this.child[i];
            if (!string.equals(agent.serno)) continue;
            return agent;
        }
        return null;
    }

    public Agent findLocal_BySerno(String string) {
        for (int i = 0; i < this._child.length; ++i) {
            Agent agent = this._child[i];
            if (!string.equals(agent.serno)) continue;
            return agent;
        }
        return null;
    }

    public void add(Agent agent, int n) {
        Agent[] agentArray;
        Agent agent2 = this.getBase();
        if (agent2 instanceof Top) {
            agentArray = (Agent[])agent2;
            agentArray.genSym(agent);
        }
        agentArray = new Agent[this.child.length + 1];
        System.arraycopy(this.child, 0, agentArray, 0, n);
        agentArray[n] = agent;
        System.arraycopy(this.child, n, agentArray, n + 1, this.child.length - n);
        this.child = agentArray;
        agent.father = this;
    }

    public boolean register(Agent agent, int n) {
        this.add(agent, n);
        return true;
    }

    public void remove(int n) {
        Agent agent = this.child[n];
        Agent[] agentArray = new Agent[this.child.length - 1];
        System.arraycopy(this.child, 0, agentArray, 0, n);
        System.arraycopy(this.child, n + 1, agentArray, n, this.child.length - n - 1);
        this.child = agentArray;
        agent.father = null;
    }

    public void unregister(int n) {
        this.remove(n);
    }

    public void removeall() {
        for (int i = this.child.length - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public void unregisterall() {
        for (int i = this.child.length - 1; i >= 0; --i) {
            this.unregister(i);
        }
    }

    private Agent[] shuffleArray(Agent[] agentArray) {
        Top top = (Top)this.get_Base();
        Agent[] agentArray2 = (Agent[])agentArray.clone();
        System.arraycopy(agentArray, 0, agentArray2, 0, agentArray.length);
        for (int i = 0; i < agentArray.length; ++i) {
            int n = i + Math.abs(top.getRandom().nextInt()) % (agentArray.length - i);
            Agent agent = agentArray2[n];
            agentArray2[n] = agentArray2[i];
            agentArray2[i] = agent;
        }
        return agentArray2;
    }

    public void condition() {
        this._child = (Agent[])this.reclone(this.child, this._child);
        this._randomize = this.randomize;
        super.condition();
    }

    public void prepare() {
        super.prepare();
        for (int i = 0; i < this.child.length; ++i) {
            this.child[i].prepare();
        }
    }

    void execute() {
        if (this._active) {
            if (this._randomize) {
                Agent[] agentArray = this.shuffleArray(this._child);
                for (int i = 0; i < this._child.length; ++i) {
                    agentArray[i].execute();
                }
            } else {
                for (int i = 0; i < this._child.length; ++i) {
                    this._child[i].execute();
                }
            }
        }
        super.execute();
    }

    public Agent findBySerno(String string) {
        Agent agent = super.findBySerno(string);
        if (agent != null) {
            return agent;
        }
        for (int i = this.child.length - 1; i >= 0; --i) {
            agent = this.child[i].findBySerno(string);
            if (agent == null) continue;
            return agent;
        }
        return null;
    }

    public Agent find_BySerno(String string) {
        Agent agent = super.find_BySerno(string);
        if (agent != null) {
            return agent;
        }
        for (int i = this._child.length - 1; i >= 0; --i) {
            agent = this._child[i].find_BySerno(string);
            if (agent == null) continue;
            return agent;
        }
        return null;
    }

    public int getChildCount() {
        return this.child.length;
    }

    public int get_ChildCount() {
        return this._child.length;
    }

    public Agent getNthChild(int n) {
        return this.child[n];
    }

    public Agent get_NthChild(int n) {
        return this._child[n];
    }
}

