/*
 * Decompiled with CFR 0.152.
 */
package eawag.model;

import eawag.model.Agent;
import eawag.model.Fixup;
import eawag.model.Swarm;
import java.io.PrintStream;
import java.util.Vector;

public abstract class AbstractCloner {
    protected Agent src;
    protected Agent dst;
    public Vector res;
    public StringBuffer sb;

    public void setSrc(Agent agent) {
        this.src = agent;
    }

    public void setDst(Agent agent) {
        this.dst = agent;
    }

    protected Agent corrAgent(Agent agent) {
        if (this.src == agent) {
            return this.dst;
        }
        if (agent.father == null) {
            return null;
        }
        Swarm swarm = (Swarm)this.corrAgent(agent.father);
        if (swarm == null) {
            return null;
        }
        int n = agent.father.indexOf(agent);
        return swarm.child[n];
    }

    public void linkFixups(Fixup[] fixupArray, PrintStream printStream) {
        for (int i = 0; i < fixupArray.length; ++i) {
            Fixup fixup = fixupArray[i];
            Agent agent = this.src.findBySerno(fixup.obj);
            if (agent != null) {
                try {
                    Agent agent2 = this.src.findBySerno(fixup.tvalue);
                    if (agent2 != null) {
                        this.setValue(agent, fixup.tpath, agent2);
                        continue;
                    }
                    printStream.println("Value " + fixup.tvalue + " not found");
                }
                catch (Exception exception) {
                    printStream.println("Path " + fixup.obj + fixup.tpath + " troublesome");
                }
                continue;
            }
            printStream.println("Target " + fixup.obj + " not found");
        }
    }

    public Agent duplicateSkeleton(Agent agent, Agent agent2) throws IllegalAccessException, InstantiationException {
        Class<?> clazz = agent2.getClass();
        if (agent == null || agent.getClass() != clazz) {
            agent = (Agent)this.createInstance(clazz);
        }
        if (agent2 instanceof Swarm) {
            Swarm swarm = (Swarm)agent;
            Swarm swarm2 = (Swarm)agent2;
            if (swarm.child.length != swarm2.child.length) {
                Agent[] agentArray = new Agent[swarm2.child.length];
                System.arraycopy(swarm.child, 0, agentArray, 0, Math.min(swarm.child.length, agentArray.length));
                swarm.child = agentArray;
            }
            for (int i = 0; i < swarm2.child.length; ++i) {
                agent2 = this.duplicateSkeleton(swarm.child[i], swarm2.child[i]);
                agent2.father = swarm;
                swarm.child[i] = agent2;
            }
        }
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillSkeleton(Agent agent, Agent agent2) throws InstantiationException, IllegalAccessException {
        try {
            this.duplicateContent(agent2, false, agent);
        }
        finally {
            this.endShared();
        }
        if (agent2 instanceof Swarm) {
            Swarm swarm = (Swarm)agent;
            Swarm swarm2 = (Swarm)agent2;
            for (int i = 0; i < swarm2.child.length; ++i) {
                this.fillSkeleton(swarm.child[i], swarm2.child[i]);
            }
        }
    }

    public abstract Object createInstance(Class var1) throws IllegalAccessException, InstantiationException;

    public abstract void endShared();

    public abstract Object duplicateContent(Object var1, boolean var2, Object var3) throws IllegalAccessException, InstantiationException;

    public abstract void setValue(Object var1, String var2, Object var3) throws IllegalAccessException;
}

