/*
 * Decompiled with CFR 0.152.
 */
package eawag.grid;

import eawag.grid.Bug;
import eawag.grid.Depiction;
import eawag.model.Agent;
import eawag.model.Swarm;

public class Grid
extends Swarm {
    public int xsize = 12;
    public int ysize = 12;
    public int zsize = 2;
    public Bug[][][] bugs = new Bug[this.zsize][this.xsize][this.ysize];
    public transient int _xsize = 12;
    public transient int _ysize = 12;
    public transient int _zsize = 2;
    public transient Bug[][][] _bugs;
    public transient Depiction lastdepiction;
    public transient int zlow = 0;
    public transient int zhigh = Integer.MAX_VALUE;
    public transient Bug[][][] flyer;
    public transient int fromz;
    public transient int toz;
    public transient int fromx;
    public transient int tox;
    public transient int fromy;
    public transient int toy;

    public void condition() {
        this._bugs = (Bug[][][])this.reclone(this.bugs, this._bugs);
        this._xsize = this.xsize;
        this._ysize = this.ysize;
        this._zsize = this.zsize;
        super.condition();
    }

    public Bug getRaw(int n, int n2, int n3) {
        return this.bugs[n3][n][n2];
    }

    public Bug getComposite(int n, int n2, int n3) {
        Bug bug;
        if (this.flyer != null && this.fromz <= n3 && n3 < this.toz && this.fromx <= n && n < this.tox && this.fromy <= n2 && n2 < this.toy && (bug = this.flyer[n3 - this.fromz][n - this.fromx][n2 - this.fromy]) != null) {
            return bug;
        }
        return this.bugs[n3][n][n2];
    }

    public void setRaw(int n, int n2, int n3, Bug bug) {
        this.bugs[n3][n][n2] = bug;
    }

    public void setSize(int n, int n2, int n3) {
        if (this.xsize == n && this.ysize == n2 && this.zsize == n3) {
            return;
        }
        Bug[][][] bugArray = new Bug[n3][n][n2];
        for (int i = 0; i < this.zsize; ++i) {
            for (int j = 0; j < this.xsize; ++j) {
                for (int k = 0; k < this.ysize; ++k) {
                    Bug bug = this.bugs[i][j][k];
                    if (bug == null) continue;
                    if (i < n3 && j < n && k < n2) {
                        bugArray[i][j][k] = bug;
                        continue;
                    }
                    bug.leave();
                }
            }
        }
        this.xsize = n;
        this.ysize = n2;
        this.zsize = n3;
        this.bugs = bugArray;
    }

    public Bug getBug(int n, int n2, int n3) {
        if ((n %= this.xsize) < 0) {
            n += this.xsize;
        }
        if ((n2 %= this.ysize) < 0) {
            n2 += this.ysize;
        }
        if ((n3 %= this.zsize) < 0) {
            n3 += this.zsize;
        }
        return this.bugs[n3][n][n2];
    }

    public Bug get_Bug(int n, int n2, int n3) {
        if ((n %= this._xsize) < 0) {
            n += this._xsize;
        }
        if ((n2 %= this._ysize) < 0) {
            n2 += this._ysize;
        }
        if ((n3 %= this._zsize) < 0) {
            n3 += this._zsize;
        }
        return this._bugs[n3][n][n2];
    }

    public void unregister(int n) {
        Agent agent = this.child[n];
        if (agent instanceof Bug) {
            Bug bug = (Bug)agent;
            if (bug.flyer) {
                this.setFlyer(bug.x, bug.y, bug.z, null);
            } else {
                this.setRaw(bug.x, bug.y, bug.z, null);
            }
        }
        super.unregister(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean register(Agent agent, int n) {
        if (!(agent instanceof Bug)) return super.register(agent, n);
        Bug bug = (Bug)agent;
        if (bug.flyer) {
            int n2;
            int n3;
            int n4 = bug.x % (this.tox - this.fromx);
            if (n4 < 0) {
                n4 += this.tox - this.fromx;
            }
            if ((n3 = bug.y % (this.toy - this.fromy)) < 0) {
                n3 += this.toy - this.fromy;
            }
            if ((n2 = bug.z % (this.toz - this.fromz)) < 0) {
                n2 += this.toz - this.fromz;
            }
            if (this.getFlyer(n4, n3, n2) != null) return false;
            this.setFlyer(n4, n3, n2, bug);
            bug.x = n4;
            bug.y = n3;
            bug.z = n2;
            return super.register(agent, n);
        } else {
            int n5;
            int n6;
            int n7 = bug.x % this.xsize;
            if (n7 < 0) {
                n7 += this.xsize;
            }
            if ((n6 = bug.y % this.ysize) < 0) {
                n6 += this.ysize;
            }
            if ((n5 = bug.z % this.zsize) < 0) {
                n5 += this.zsize;
            }
            if (this.getRaw(n7, n6, n5) != null) return false;
            this.setRaw(n7, n6, n5, bug);
            bug.x = n7;
            bug.y = n6;
            bug.z = n5;
        }
        return super.register(agent, n);
    }

    public int getLow() {
        return Math.min(this.zlow, this.zsize);
    }

    public int getHigh() {
        return Math.max(this.getLow(), Math.min(this.zhigh, this.zsize));
    }

    public void setLow(int n) {
        this.zlow = n;
    }

    public void setHigh(int n) {
        this.zhigh = n;
    }

    public Bug getFlyer(int n, int n2, int n3) {
        return this.flyer[n3][n][n2];
    }

    public void setFlyer(int n, int n2, int n3, Bug bug) {
        this.flyer[n3][n][n2] = bug;
    }
}

