/*
 * Decompiled with CFR 0.152.
 */
package eawag.grid;

import eawag.grid.Depiction;
import eawag.grid.Grid;
import eawag.model.Swarm;
import eawag.model.Top;

public class Bug
extends Swarm {
    public Depiction depict;
    public String label;
    public int x;
    public int y;
    public int z;
    public transient Depiction _depict;
    public transient String _label;
    public transient int _x;
    public transient int _y;
    public transient int _z;
    public boolean flyer;

    public void condition() {
        this._z = this.z;
        this._y = this.y;
        this._x = this.x;
        this._label = this.label;
        this._depict = this.depict;
        super.condition();
    }

    public boolean moveBug(int n, int n2, int n3) {
        Grid grid = (Grid)this.father;
        if (grid == null) {
            this.x = n;
            this.y = n2;
            this.z = n3;
            return true;
        }
        if (this.flyer) {
            if ((n %= grid.tox - grid.fromx) < 0) {
                n += grid.tox - grid.fromx;
            }
            if ((n2 %= grid.toy - grid.fromy) < 0) {
                n2 += grid.toy - grid.fromy;
            }
            if ((n3 %= grid.toz - grid.fromz) < 0) {
                n3 += grid.toz - grid.fromz;
            }
            if (this.x != n || this.y != n2 || this.z != n3) {
                if (grid.getFlyer(n, n2, n3) != null) {
                    return false;
                }
                grid.setFlyer(this.x, this.y, this.z, null);
                grid.setFlyer(n, n2, n3, this);
                this.x = n;
                this.y = n2;
                this.z = n3;
            }
            return true;
        }
        if ((n %= grid.xsize) < 0) {
            n += grid.xsize;
        }
        if ((n2 %= grid.ysize) < 0) {
            n2 += grid.ysize;
        }
        if ((n3 %= grid.zsize) < 0) {
            n3 += grid.zsize;
        }
        if (this.x != n || this.y != n2 || this.z != n3) {
            if (grid.getRaw(n, n2, n3) != null) {
                return false;
            }
            grid.setRaw(this.x, this.y, this.z, null);
            grid.setRaw(n, n2, n3, this);
            this.x = n;
            this.y = n2;
            this.z = n3;
        }
        return true;
    }

    public boolean moveRandom() {
        Grid grid = (Grid)this._father;
        if (grid == null) {
            return false;
        }
        int[] nArray = new int[8];
        int n = 0;
        if (grid.get_Bug(this._x + 1, this._y, this._z) == null) {
            nArray[n++] = 0;
        }
        if (grid.get_Bug(this._x + 1, this._y + 1, this._z) == null) {
            nArray[n++] = 1;
        }
        if (grid.get_Bug(this._x, this._y + 1, this._z) == null) {
            nArray[n++] = 2;
        }
        if (grid.get_Bug(this._x - 1, this._y + 1, this._z) == null) {
            nArray[n++] = 3;
        }
        if (grid.get_Bug(this._x - 1, this._y, this._z) == null) {
            nArray[n++] = 4;
        }
        if (grid.get_Bug(this._x - 1, this._y - 1, this._z) == null) {
            nArray[n++] = 5;
        }
        if (grid.get_Bug(this._x, this._y - 1, this._z) == null) {
            nArray[n++] = 6;
        }
        if (grid.get_Bug(this._x + 1, this._y - 1, this._z) == null) {
            nArray[n++] = 7;
        }
        if (n == 0) {
            return false;
        }
        Top top = (Top)this.get_Base();
        int n2 = Math.abs(top.getRandom().nextInt()) % n;
        switch (nArray[n2]) {
            case 0: {
                return this.moveBug(this._x + 1, this._y, this._z);
            }
            case 1: {
                return this.moveBug(this._x + 1, this._y + 1, this._z);
            }
            case 2: {
                return this.moveBug(this._x, this._y + 1, this._z);
            }
            case 3: {
                return this.moveBug(this._x - 1, this._y + 1, this._z);
            }
            case 4: {
                return this.moveBug(this._x - 1, this._y, this._z);
            }
            case 5: {
                return this.moveBug(this._x - 1, this._y - 1, this._z);
            }
            case 6: {
                return this.moveBug(this._x, this._y - 1, this._z);
            }
        }
        return this.moveBug(this._x + 1, this._y - 1, this._z);
    }

    public int nextTo(Depiction depiction) {
        Grid grid = (Grid)this._father;
        if (grid == null) {
            return 0;
        }
        int n = 0;
        Bug bug = grid.get_Bug(this._x + 1, this._y, this._z);
        if (bug != null && bug._depict == depiction) {
            ++n;
        }
        if ((bug = grid.get_Bug(this._x + 1, this._y + 1, this._z)) != null && bug._depict == depiction) {
            ++n;
        }
        if ((bug = grid.get_Bug(this._x, this._y + 1, this._z)) != null && bug._depict == depiction) {
            ++n;
        }
        if ((bug = grid.get_Bug(this._x - 1, this._y + 1, this._z)) != null && bug._depict == depiction) {
            ++n;
        }
        if ((bug = grid.get_Bug(this._x - 1, this._y, this._z)) != null && bug._depict == depiction) {
            ++n;
        }
        if ((bug = grid.get_Bug(this._x - 1, this._y - 1, this._z)) != null && bug._depict == depiction) {
            ++n;
        }
        if ((bug = grid.get_Bug(this._x, this._y - 1, this._z)) != null && bug._depict == depiction) {
            ++n;
        }
        if ((bug = grid.get_Bug(this._x + 1, this._y - 1, this._z)) != null && bug._depict == depiction) {
            ++n;
        }
        return n;
    }

    public boolean levelBug(boolean bl) {
        int n;
        int n2;
        if (bl == this.flyer) {
            return true;
        }
        Grid grid = (Grid)this.father;
        if (grid == null) {
            this.flyer = bl;
            return true;
        }
        if (bl) {
            int n3;
            int n4;
            int n5 = (this.x - grid.fromx) % (grid.tox - grid.fromx);
            if (n5 < 0) {
                n5 += grid.tox - grid.fromx;
            }
            if ((n4 = (this.y - grid.fromy) % (grid.toy - grid.fromy)) < 0) {
                n4 += grid.toy - grid.fromy;
            }
            if ((n3 = (this.z - grid.fromz) % (grid.toz - grid.fromz)) < 0) {
                n3 += grid.toz - grid.fromz;
            }
            if (grid.getFlyer(n5, n4, n3) == null) {
                this.flyer = bl;
                grid.setRaw(this.x, this.y, this.z, null);
                grid.setFlyer(n5, n4, n3, this);
                this.x = n5;
                this.y = n4;
                this.z = n3;
                return true;
            }
            return false;
        }
        int n6 = (this.x + grid.fromx) % grid.xsize;
        if (n6 < 0) {
            n6 += grid.xsize;
        }
        if ((n2 = (this.y + grid.fromy) % grid.ysize) < 0) {
            n2 += grid.ysize;
        }
        if ((n = (this.z + grid.fromz) % grid.zsize) < 0) {
            n += grid.zsize;
        }
        if (grid.getRaw(n6, n2, n) == null) {
            this.flyer = bl;
            grid.setFlyer(this.x, this.y, this.z, null);
            grid.setRaw(n6, n2, n, this);
            this.x = n6;
            this.y = n2;
            this.z = n;
            return true;
        }
        return false;
    }
}

